unit DemoComp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBShareware,  DBSharewareLock;



type


  TDEMOComp = class(TComponent)
  private
    FRegistration: TDBRegLock;
    FExpired  : Boolean;
    FClockChanged : Boolean;


    procedure DoOnClockChange(Sender: TObject) ;
    procedure DoOnExpire(Sender: TObject) ;
    procedure DoOnNagScreen(Sender: TObject) ;

    { Private declarations }
  protected
    { Protected declarations }



  public
    { Public declarations }
    Constructor Create(AOwner: TComponent); override;
    Procedure Loaded; override;
  published
    { Published declarations }


    Property Registration : TDBRegLock Read FRegistration Write FRegistration;
  end;

procedure Register;

implementation


procedure Register;
begin
  { Register the Demo component   }
  RegisterComponents('SETI', [TDEMOComp]);
end;

constructor TDEMOComp.Create(AOwner: TComponent);
begin
inherited;



  Registration :=   TDBSharewareLock.LockComponent(TDEMOComp, 145875543, 100, 30 ,'{C94DE3E6-3915-48E8-BC42-4B0FEA0473C9}',
                true, true, 30,25 ,DoOnClockChange, DoOnExpire, DoOnNagScreen );

end;


procedure TDEMOComp.Loaded;
begin
  inherited;
  FClockChanged := false;
  FExpired := false;


end;

{ TLockOn }


procedure TDEMOComp.DoOnClockChange(Sender: TObject);
begin
  Showmessage('The clock date has been changed in an unregistered version of '+ self.classname+ '- you need to register it in order to continue using it');
  FClockChanged := true;
end;

procedure TDEMOComp.DoOnExpire(Sender: TObject);
begin
  Showmessage(self.classname + ' has expired - you need to register it in order to continue using it');
  FExpired := true;
end;

procedure TDEMOComp.DoOnNagScreen(Sender: TObject);
begin
  Showmessage('Register '+ self.classname);
end;

initialization
  RegisterClass(TDEMOComp);

end.



